package com.agilex.healthcare.veteranappointment.dataservice;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifiers;
import gov.va.vamf.scheduling.direct.datalayer.user.VarPatientCorrelationGateway;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * Created with IntelliJ IDEA.
 * User: patelh
 * Date: 12/2/13
 * Time: 10:12 PM
 * To change this template use File | Settings | File Templates.
 */
@Component
public class PatientCorrelationService {

    @Resource
    VarPatientCorrelationGateway patientCorrelationGateway;

    public PatientIdentifier translateIDFromEDIPIToVistA(PatientIdentifier edipiPatientIdentifier, String siteCode){
        PatientIdentifiers patientIdentifiers = patientCorrelationGateway.getCorrespondIdentifiers(edipiPatientIdentifier);
        if(patientIdentifiers.size() > 0){
            for (PatientIdentifier patientIdentifier : patientIdentifiers){
                String assigningAuthority = "dfn-" + siteCode;
                if(patientIdentifier.getAssigningAuthority().equals(assigningAuthority)){
                    return patientIdentifier;
                }
            }
        }
        return edipiPatientIdentifier;
    }
}
